use Test::More;

use Reporter::Class;

require_ok( 'Reporter::Test' ); # Data::Printer, Mooo, etc

use Reporter::Test;
my $t = Reporter::Test->new;

my $invalid_lab_number = { lab_number => 200,     };
my $valid_lab_number   = { lab_number => '200/15' };

my %report = (
    status => 'new', specimen_quality => 'poor', diagnosis_id => 1,
);

my $app_validator   = $t->app->validator; # HTML::FormHandler
my $model_validator = $t->app->model->validator; # DFV

{ # invalid lab number (Data::FormValidator):
    my $res = $model_validator->validate( search => $invalid_lab_number ); # p $res;
    is( $res->{failed}, 1, 'OK: lab number validation failed' );
}

{ # valid lab number (Data::FormValidator):
    my $res = $model_validator->validate( search => $valid_lab_number ); # p $res;
    is( $res->{success}, 1, 'OK: lab number validation passed');
}

{ # invalid lab number (HTML::FormHandler):
    my $res = $app_validator->validate( search_form => $invalid_lab_number ); # p $res;
    is( $res->{failed}, 1, 'OK: lab number validation failed' );
}

{ # valid lab number (HTML::FormHandler):
    my $res = $app_validator->validate( search_form => $valid_lab_number ); # p $res;
    is( $res->{success}, 1, 'OK: lab number validation passed' );
}

{ # valid report form (HTML::FormHandler):
    my $res = $app_validator->validate( report_form => \%report ); # p $res;
    is( $res->{success}, 1, 'OK: report form validation passed');
}

{ # invalid report form (HTML::FormHandler):
    local $report{diagnosis_id} = undef;
    my $res = $app_validator->validate( report_form => \%report ); # p $res;
    is( $res->{failed}, 1, 'OK: report form validation failed');
}

{ # valid report form (Data::FormValidator):
    my $res = $model_validator->validate( report => \%report ); # p $res;
    is( $res->{success}, 1, 'OK: report form validation passed');
}

{ # invalid report form (Data::FormValidator):
    local $report{diagnosis_id} = undef;
    my $res = $model_validator->validate( report => \%report ); # p $res;
    is( $res->{failed}, 1, 'OK: report form validation failed');
}

{ # non-validated params ignored (HTML::FormHandler):
    local $report{dog} = 1;
    my $res = $app_validator->validate( report_form => \%report ); # p $res;
    isnt( $res->{valid}->{dog}, 1, 'OK: non-validated param ignored' );
}

{ # non-validated params ignored (Data::FormValidator):
    local $report{cat} = 1;
    my $res = $model_validator->validate( report => \%report ); # p $res;
    isnt( $res->{valid}->{cat}, 1, 'OK: non-validated param ignored' );
}

{ # invalid report form (Data::FormValidator):
    local $report{_require_biopsy_details} = 1;
    my $res = $model_validator->validate( report => \%report ); # p $res;
    is( $res->{failed}, 1, 'OK: report form validation failed');
    
}

{ # invalid report form (HTML::FormHandler):
    local $report{_require_biopsy_details} = 1;
    my $res = $app_validator->validate( report_form => \%report ); # p $res;
    is( $res->{failed}, 1, 'OK: report form validation failed');
}

{ # valid report form (Data::FormValidator):
    local $report{_require_biopsy_details} = 1;
    local $report{biopsy_site} = 'biopsy details';
    my $res = $model_validator->validate( report => \%report ); # p $res;
    is( $res->{success}, 1, 'OK: report form validation passed');
}

{ # valid report form (HTML::FormHandler):
    local $report{_require_biopsy_details} = 1;
    local $report{biopsy_site} = 'biopsy details';
    my $res = $app_validator->validate( report_form => \%report ); # p $res;
    is( $res->{success}, 1, 'OK: report form validation passed');
}

{ # invalid report form (Data::FormValidator):
    local $report{_require_gross_description} = 1;
    my $res = $model_validator->validate( report => \%report ); # p $res;
    is( $res->{failed}, 1, 'OK: report form validation failed');    
}

{ # invalid report form (HTML::FormHandler):
    local $report{_require_gross_description} = 1;
    my $res = $app_validator->validate( report_form => \%report ); # p $res;
    is( $res->{failed}, 1, 'OK: report form validation failed');
}

{ # valid report form (Data::FormValidator):
    local $report{_require_gross_description} = 1;
    local $report{gross_description} = 'gross description';
    my $res = $model_validator->validate( report => \%report ); # p $res;
    is( $res->{success}, 1, 'OK: report form validation passed');
}

{ # valid report form (HTML::FormHandler):
    local $report{_require_gross_description} = 1;
    local $report{gross_description} = 'gross description';
    my $res = $app_validator->validate( report_form => \%report ); # p $res;
    is( $res->{success}, 1, 'OK: report form validation passed');
}

{ # optional field (HTML::FormHandler):
    local $report{morphology} = 'morphological description';
    my $res = $app_validator->validate( report_form => \%report ); # p $res;
    is( $res->{valid}->{morphology}, $report{morphology}, 'OK: optional field present');
}

{ # optional field (Data::FormValidator):
    local $report{comment} = 'comment text block';
    my $res = $model_validator->validate( report => \%report ); # p $res;
    is( $res->{valid}->{comment}, $report{comment}, 'OK: optional field present');
}

{ # invalid field (HTML::FormHandler):
    local $report{secondary_diagnosis_id} = 'word';
    my $res = $app_validator->validate( report_form => \%report ); # p $res;
    is( $res->{failed}, 1, 'OK: report form validation failed');
}

SKIP:
{ # valid field (Data::FormValidator):
    skip('DFV profile needs constraint_methods',1);
    local $report{secondary_diagnosis_id} = 'word';
    my $res = $model_validator->validate( report => \%report ); # p $res;
    is( $res->{failed}, 1, 'OK: report form validation failed');
}

done_testing(23);