package Reporter::Validator;
 
use Reporter::Class;

use HTTP::Validate qw{:keywords :validators};

define_ruleset( 'filters' => 
    { param => 'lab_number', valid => MATCH_VALUE( qr{\d+/\d{2}} ) },
        "Return all datasets associated with the given latitude.",
);
=begin
define_ruleset( 'display' => 
    { optional => 'full', valid => FLAG_VALUE },
        "If specified, then the full dataset descriptions are returned.  No value is necessary",
    { optional => 'short', valid => FLAG_VALUE },
        "If specified, then a brief summary of the datasets is returned.  No value is necessary",
    { at_most_one => ['full', 'short'] },
    { optional => 'limit', valid => [POS_ZERO_VALUE, ENUM('all')], default => 'all',
      errmsg => "acceptable values for 'limit' are either 'all', 0, or a positive integer" },
        "Limits the number of results returned.  Acceptable values are 'all', 0, or a positive integer.",
);
=cut 
define_ruleset( 'dataset_query' =>
    "This URL queries for stored datasets.  The following parameters select the datasets",
    "to be displayed, and you must specify at least one of them:",
    { require => 'filters',
      errmsg => "you must specify at least one of the following: 'lat' and 'lng', 'id', 'name'" },
#    "The following optional parameters control how the data is returned:",
#    { allow => 'display' },
);

sub validate {
    my ($self, $params) = @_; # p $foo;
    
    my $result = check_params('dataset_query', {}, $params);

    my %h = (
        errors  => $result->errors   || 0, # empty if validation passed
        success => $result->passed   || 0, # empty if validation failed
        failed  => ! $result->passed || 1, # empty if validation failed
    ); # p %h;
    return \%h;
}

1;