package Reporter::Validation;

use HTML::FormHandler::Moose;
extends 'HTML::FormHandler';
use Moose::Util::TypeConstraints;

has_field lab_number => (
    required => 1,    
    type     => 'Text',
    apply    => [ 'LabNumFormat' ],
);


has_field diagnosis_id => (
    required => 0,   # needs to be separate profile 
    type     => 'Integer',
);

subtype 'LabNumFormat'
   => as 'Str'
   => where { $_ =~ m!\d+/\d{2}! }
   => message { 'lab number format incorrect: require nnn/yy' };

no HTML::FormHandler::Moose;

1;
