package Reporter::Validation;
# called as $app->validator->validate( <form_name> => $params ); eg search_form => $params

use Reporter::Class;

has search_form => (
    is => 'lazy',
    builder => sub { Reporter::Validation::SearchForm->new } );
has report_form => (
    is => 'lazy',
    builder => sub { Reporter::Validation::ReportForm->new } );

sub validate {
    my ($self, $profile_name, $params) = @_; # ddp $params;

    my $validator = $self->${profile_name};
    my $result = $validator->run( params => $params ); # ddp $result->all_error_results;
 
    # create equivalent of DFV valid hashref:
    my $valid = clone $result->fif; # ddp $valid;
    # delete key if name accessor in all_error_results (indicates failure):
    delete $valid->{$_->name} for $result->all_error_results; # ddp $valid;
    
    my %dfv_errs = map +( $_->name => join ', ', @{ $_->errors } ),
        $result->all_error_results; # ddp %dfv_errs;

    my %h = (
        dfv_errs => \%dfv_errs,
        success  => ! $result->has_errors || 0, # ie $ref->{success} or $ref->{failed}
        failed   => $result->has_errors, # true or false
        errors   => $result->errors, # arrayref, empty if validation passed
        valid    => $valid,
    ); # ddp %h;
    return \%h;
}

1;

#===============================================================================
package Reporter::Validation::SearchForm;

use HTML::FormHandler::Moose;
extends 'HTML::FormHandler';
use Moose::Util::TypeConstraints;

has_field lab_number => (
    type  => 'Text',
    apply => [ 'LabNumFormat' ],
);

subtype 'LabNumFormat'
   => as 'Str'
   => where { $_ =~ m!\d+/\d{2}! }
   => message { 'lab number format incorrect: require nnn/yy' };

no HTML::FormHandler::Moose;
1;

#===============================================================================
package Reporter::Validation::ReportForm;

use HTML::FormHandler::Moose;
extends 'HTML::FormHandler';
use Moose::Util::TypeConstraints;

has_field diagnosis_id => (
    type => 'Integer',
    required => 1,
);

has_field status => (
    type => 'Text',
    required => 1,
);

has_field specimen_quality => (
    type => 'Text',
    required => 1,
);

has_field _require_biopsy_details => (
    type => 'Hidden',
);

has_field biopsy_site => (
    type => 'Text',
    required_when => { _require_biopsy_details => 1 },
);

has_field _require_gross_description => (
    type => 'Hidden',    
);

has_field gross_description => (
    type => 'Text',
    required_when => { _require_gross_description => 1 },
);

has_field morphology => (
    type => 'Text',
    required => 0,
);

has_field comment => (
    type => 'Text',
    required => 0,
);

has_field request_notes => (
    type => 'Text',
    required => 0,
);

has_field clinical_details => (
    type => 'Text',
    required => 0,
);

has_field secondary_diagnosis_id => (
    type => 'Integer',
    required => 0,
);

no HTML::FormHandler::Moose;
1;
