package Reporter::Routes::AJAX;

use Dancer2 app => 'Reporter::Routes';

set serializer => 'JSON';

our $app; # defined in Reporter::Routes

hook before => sub { $app->check_db_connection }; # to ensure dbh still connected

get '/ajax_get_diagnoses' => sub {
	my $diagnoses = $app->model->get_diagnoses( param('diagnosis') )
	|| return; # p $diagnoses; # doesn't do query unless str >= 3 chars

    my @results = map {
        {
            id    => $_->{id},
            value => $_->{diagnosis},
            info  => $_->{icdo3} || '[non-ICDO3]',
        }
    } @$diagnoses; # p @results;

    my $json = { results => \@results }; # p $json;
    return $json;
};

1;
