use Test::More;

use Reporter::Class;

require_ok( 'Reporter::Test' ); # Data::Printer, Mooo, etc

use Reporter::Test;

my $t = Reporter::Test->new;

my $invalid_lab_number = { lab_number => 200 };
my $valid_lab_number   = { lab_number => '200/15' };

my $model_validator = $t->app->validator; # DFV
my $app_validator   = $t->app->model->validator; # HTML::FormHandler

{ # invalid lab number (Data::FormValidator):
    my $res = $model_validator->validate( search_form => $invalid_lab_number ); # p $res;
    is( $res->{failed}, 1, 'OK: lab number validation failed' );
}

{ # valid lab number (Data::FormValidator):
    my $res = $model_validator->validate( search_form => $valid_lab_number ); # p $res;
    is( $res->{success}, 1, 'OK: lab number validation passed');
}

{ # invalid lab number (HTML::FormHandler):
    my $res = $app_validator->validate( search => $invalid_lab_number ); # p $res;
    is( $res->{failed}, 1, 'OK: lab number validation failed' );
}

{ # valid lab number (HTML::FormHandler):
    my $res = $app_validator->validate( search => $valid_lab_number ); # p $res;
    is( $res->{success}, 1, 'OK: lab number validation passed' );
}

done_testing(5);