package Reporter::Validation;
# called as $app->validator->validate( <form_name> => $params ); eg search_form => $params

use Moo;
has search_form => (
    is => 'lazy',
    builder => sub { Reporter::Validation::SearchForm->new } );
has report_form => (
    is => 'lazy',
    builder => sub { Reporter::Validation::ReportForm->new } );

sub validate {
    my ($self, $profile_name, $params) = @_; # p $params;

    my $validator = $self->${profile_name};
    my $result = $validator->run( params => $params ); # p $result;
# TODO: return same errs data structure as DFV so can be used interchangably
    my %h = (
        errors  => $result->errors, # empty if validation passed
        failed  => $result->has_errors, # true or false
        success => ! $result->has_errors, # ie $ref->{success} or $ref->{failed}
    ); # p %h;
    return \%h;
}

1;

#===============================================================================
package Reporter::Validation::SearchForm;

use HTML::FormHandler::Moose;
extends 'HTML::FormHandler';
use Moose::Util::TypeConstraints;

has_field lab_number => (
    type  => 'Text',
    apply => [ 'LabNumFormat' ],
);

subtype 'LabNumFormat'
   => as 'Str'
   => where { $_ =~ m!\d+/\d{2}! }
   => message { 'lab number format incorrect: require nnn/yy' };

no HTML::FormHandler::Moose;
1;

#===============================================================================
package Reporter::Validation::ReportForm;

use HTML::FormHandler::Moose;
extends 'HTML::FormHandler';
use Moose::Util::TypeConstraints;

has_field diagnosis_id => (
    type    => 'Integer',
    reqired => 1,
);

no HTML::FormHandler::Moose;
1;

