package Reporter;

use Reporter::Model;
use Reporter::Validation;
use Reporter::Class; # provides Moo, Modern::Perl, Local::MooX::Types & Data::Printer::p

use FindBin qw($RealBin); # warn $RealBin;
use Path::Tiny;
use Git;

my $git = Git->repository(Directory => path($RealBin, '..', '.git')->realpath);
our $VERSION = version(); # warn $VERSION;
say sprintf('>> starting Reporter v%s', $VERSION); # unless $ENV{HARNESS_ACTIVE};

has dbname  => ( is => 'ro', isa => String, required => 1 ); # hilis4, test, etc
has config  => ( is => 'ro', isa => HashReference, required => 1 );
has model => (
    is => 'lazy',
    handles => [ 'check_db_connection' ], # to check db handle still connected
);
has validator => ( # Data::FormValidator:
    is => 'lazy',
    builder  => sub { Reporter::Validation->new( dbname => shift->dbname ) }
);

sub enable_sql_trace { $ENV{SQL_TRACE} = 1 }

sub symbolise { Local::Utils::symbolise($_[1]) }

sub version { $git->command_oneline('rev-list', 'HEAD', '--count') }

sub gitlog {
    my @args = ( '--pretty=format:"%ad :: %s"', '--date=relative' );
    my @log = $git->command( 'log', @args );
    return \@log;
};

sub _build_model {
    my $self = shift;
    my %args = (
        dbname  => $self->dbname,
        config  => $self->config,
    );
    Reporter::Model->new(%args);
}

1;
