package Reporter::Routes::Test;

use Dancer2 app => 'Reporter::Routes';
use Dancer2::Plugin::Deferred;

set enable_sql_trace => 0; # don't want query logging unless explicitly set - see Routes

prefix '/test';

# to test 500.tt custom error template:
get '/error' => sub { send_error('test error message') };

# test flash/deferred:
get '/flash' => sub {
    deferred  $_ => "test flash $_ message" for qw(info warning danger); # bootstrap helper classes
    redirect '/';
};

1;
