package Reporter::Roles;

use Digest::SHA1;
use Reporter::Class; # provides Moo, Local::MooX::Types & LIMS::Local::Debug::p

sub authenticate_user {
    my ($self, $params) = @_;  p $params;
    
    my $username = $params->{username}; # username or email addr
    my $password = $params->{password};
    
    my $digest = _sha1_digest($password); p $digest;
    
    # return $user->password eq $password ? $user->username : 0;
   
    return 1;
}

sub _sha1_digest {
	my $str = shift; # warn $str;

    my $sha1 = Digest::SHA1->new;
    $sha1->add($str);

    return $sha1->b64digest;
}


1;