package DraftReporter;

use Lingua::EN::Numbers qw/num2en_ordinal/;
use Modern::Perl;

use Dancer2;
use Reporter::Roles;

our $VERSION = '0.1';

my $app = Reporter::Roles->new;

#set session => 'Cookie';
set session => 'JSON';
#set session => 'Sereal';
#set session => 'Memcached'; # defined in config.yml

=begin # probably not needed as only 1 entry point
hook before => sub {
    if (! session('user') && request->path_info !~ m!^/login!) {
        var request_path => request->path_info;
    }
};
=cut

get '/' => sub {
    session('user') || redirect('/login');
    template index => {}, { layout => 'index' };
};


get '/login' => sub {
    # display a login page; the original URL is available as vars->{request_path},
    # so could be put in a hidden field in the form
    template 'login';
};

post '/login' => sub {
    my $params = params; # p $params;
    
    # validate username/password
    if ( my $user = $app->authenticate_user($params) ) {
        session user => $user;
        redirect params->{path} || '/';
    }
    else {
        redirect '/login?failed=1';
    }
};
    
get '/logout' => sub {
    context->destroy_session;
    redirect('/'); # should redirect to /login
};

#===============================================================================
# default Dancer2 app index page:
get '/index' => sub { template 'index', {}, { layout => 'index' } };

get '/count' => sub {
  if ( my $user = session('user') ) {
    session count => session('count') + 1;
    return
      '<a href="/count">Click here</a> for the name of the eldest blob of <b> Count von '.
      ucfirst $user.' the '. ucfirst num2en_ordinal(session('count')).'</b>';
  }
  return 'Cookie Monster!';
};

get '/do_login/:user' => sub {
    session user   => params->{user};
    session count  => 0;
    redirect '/';
};

dance;
