use App::Class; # Import::Into

class App::DB {
	use Data::Printer;
    # our $DBNAME; # in case we need direct access to db name (eg DBIx::Simple)

    field $dbh :reader :param; # mandatory
    field $dsl :reader :param; # mandatory

	method find_user ($username) {
        my $user = $dbh->quick_select( users => { username => $username } ); # p $user;
        return $user;
    }

	method save_document ($data) { # p $data; # return;
        my $result = do { # choice is to capture error, or just die with db error
            try {         #  since user probably cannot do anything about it
				$dbh->quick_insert( library => $data );
				my $id = $dbh->do('select last_insert_rowid()'); # p $id;
                return { id => $id };
            }
            catch ($e) { # dsl->warning $e; # can't do it
                return { error => $e };
            }
        };
        return $result;
    }

	method get_document ($id) {
		my $entry = $dbh->quick_select( library => { id => $id } ); # p entry;
        return $entry;
	}

	method find_documents ($str) {
		my @bind = map { '%' . $str . '%' } (1..3); # p @bind;
		my $sql = q!select * from library where title like ? or keywords like ?
			or content like ?!;
		my $res = $dbh->selectall_arrayref( $sql, { Slice => {} }, @bind ); # AoH
		return $res;
	  # alternative using prepare & execute:
		# my $sth = $dbh->prepare( $sql );
		# $sth->execute(@bind);
		# my $result = $sth->fetchall_arrayref({}); # p $result; # AoH
		# return $result;
	}
}