package App::LogAnyAdapter;

# from ChatGPT session - see documents/LAA-ChatGPT.txt

use 5.34.0;

# this is from ChatGPPT session but function works OK without it:
# use Dancer2 ();          # load but don’t import the DSL
use Log::Any::Adapter;
use Data::Printer;
use App::Class;

=begin # passing log-level from D2 app now
my %level_for = (
    development => 'debug',
    production  => 'warning',
    test        => 'info',
);
my $env = Dancer2->runner->environment; warn "env:$env";
my $log_level = $level_for{$env};   warn "min_log_level:$min_log_level";
=cut

# Log::Any does not recognise 'core' as valid setting, trace is 'lowest':
my %level_for = ( core => 'trace' );

sub init { # warn $log_level;
    # Get the first registered app (single-app setup):
    my ($app) = @{ Dancer2->runner->apps };
    my $cfg = $app->config; # p $cfg

    my $log_level = $cfg->{log}; # warn $log_level;
    my $min_level = $level_for{$log_level} || $log_level; # warn $min_level;

=begin # Callback is deprecated, use Capture instead (below)
    Log::Any::Adapter->set(
        Callback => (
            min_level  => $min_level,
            logging_cb => sub ($method, $self, $str, @params) { 
              # $method = 'debug', 'info' etc; $self = Log::Any::Adapter::Callback obj
              # $str = message passed from caller; @params = ???
                my $msg = @params ? sprintf($str, @params) : $str;
                # Skip Log::Any frames so the caller is your model code - no it isn't
                my (undef, $file, $line) = caller(2); warn $file; warn $line; # caller is Route not Model
                my $msg_str = _add_caller_to_msg( $msg, $file, $line );
                $app->logger_engine->log(
                    $method => $msg_str,
                    caller  => [$file, $line],
                );
            },
        ),
    );
=cut
#=begin # Capture method
    Log::Any::Adapter->set(
        Capture => (
            format => 'messages',
            to => sub ( $level, $category, $message_text ) { # warn 'x' x 30;
                # warn $level; warn $category; warn $message_text;
                # Skip Log::Any frames so the caller is your model code - no it isn't:
                my (undef, $file, $line) = caller(2);
                # add caller info to message:
                my $msg = _add_caller_to_msg( $message_text, $file, $line );
                $app->logger_engine->log(
                    $level => $msg, 
                    caller  => [$file, $line], # <= this is ignored !!!
                );
            },
            log_level => $min_level,
        ),
    );
#=cut
}

sub _add_caller_to_msg ( $message_text, $file, $line ) {
    my $caller = join '::', ( split '/', $file )[-2, -1]; # p $caller; # last 2 elements
    $message_text .= sprintf ' [%s:#%s]', $caller, $line; # warn $message_text;
    return $message_text;
}

1;