use App::Class; # Import::Into

class App::DB;
	   
use Data::Printer;
use DBIx::Simple;
use File::Slurper 'read_text';

field $cfg  :reader :param; # mandatory
field $dbix :reader =
    DBIx::Simple->connect( 'dbi:SQLite:dbname='.$cfg->{dbname} );

ADJUST { # p $cfg->{db_init}, as => "db_init file:";
    my $dbi_trace_level = $ENV{DBI_TRACE} || 0;
    $dbix->dbh->trace('SQL|'.$dbi_trace_level);
    # init db if 1st run (creates db also if not exists)
    my $schema = read_text( $cfg->{db_init} );  # p $sql;
    my @schemata = split /\n\s*\n/, $schema;    # p @schema;
    $dbix->dbh->do($_) for @schemata; # is needed, sometimes fails to run directly
    # $dbix->dbh->do($schema);
}

method find_user ($username) { # p $dbh->{Name}; p $username;
    my $user = $dbix->select('users', '*', { username => $username })->hash; # p $user;
    return $user;
}

method total_count ($table) { $dbix->select($table => 'COUNT(*)')->list }
       
1;