use App::Class; # Import::Into

class App::Model {
    use Crypt::PBKDF2;
    use Data::Printer;
    use App::DB;

    field $dbh :reader :param; # mandatory   # if using D2::Plugin::DB
	# field $cfg :reader :param; # mandatory # if using DBIx::Simple
    field $db :reader = App::DB->new( dbh => $dbh );

	method find_user ($username) { $db->find_user($username) }

    method verify_password ($pwd, $hash) {
        Crypt::PBKDF2->new->validate($hash, $pwd); # using defaults for new()
    }
	
	method save_document ($data) {
		my $result = $self->db->save_document($data);
        return $result;
	}
}
