# from chatgpt

use strict;
use warnings;

BEGIN { # set test env otherwise get development config settings - unless explicitly
    # set at command-line: "DANCER_ENVIRONMENT=development prove -lv t/"
    $ENV{DANCER_ENVIRONMENT} ||= $ENV{PLACK_ENV} ||= 'test';
}

use Test::More;
use Plack::Test;
use Data::Printer;
use HTTP::Request::Common;

# Load the app
use_ok('DocsLib');

my $app = DocsLib->psgi_app;

test_psgi $app, sub {
    my $cb = shift; # p $cb;

    # 1. Fetch the root page
    my $res = $cb->( GET '/test/' );
    ok $res->is_success, "GET /test successful"; # p $res->content;
    like $res->content, qr{hx-get="/test/fragment"}, "root has htmx trigger";

    # 2. Simulate an htmx request for /fragment
    my $req = GET '/test/fragment';
    $req->header('HX-Request'     => 'true');        # marks it as htmx
    $req->header('HX-Current-URL' => 'http://localhost/');
    $req->header('Accept'         => 'text/html');
    $req->header('HX-Trigger'     => 'load-btn');
    $req->header('HX-Target'      => 'container');

    $res = $cb->($req);
    ok $res->is_success, "htmx fragment request successful";
    like $res->content, qr/Hello from htmx fragment/, "fragment content is correct";
    {
        my $content = $res->decoded_content; # p $content;
        like $content, qr/hx-request: true/, "hx-request header echoed";
        like $content, qr/hx-current-url: http:\/\/localhost\//, "hx-current-url echoed";
        like $content, qr/hx-trigger: load-btn/, "hx-trigger echoed";
        like $content, qr/hx-target: container/, "hx-target echoed";
    }
};

test_psgi $app, sub {
    my $cb = shift;

    # Build request with some HTMX headers
    my $req = GET '/test/dump-headers';
    $req->header('HX-Request'     => 'true');
    $req->header('HX-Current-URL' => 'http://localhost/');
    $req->header('HX-Trigger'     => 'load-btn');
    $req->header('HX-Target'      => 'container');

    my $res = $cb->($req);
    ok $res->is_success, "request successful";

    my $content = $res->decoded_content; # p $content;
    diag "---- Headers echoed by app ----\n$content\n-------------------------------";

    like $content, qr/HX-Request: true/, "saw hx-request header";
};

done_testing;