package Routes::InfoLibrary;
use Dancer2 appname => 'DocsLib';

use v5.34.0;
use Data::Printer;

use App::Model; # D2 plugin, provides 'model' keyword
use Dancer2::Plugin::Deferred;
use Dancer2::Plugin::Auth::Tiny;

my $PREFIX = 'infolib'; 
prefix "/$PREFIX";

hook before_template_render => sub { 
    my $tokens = shift;
    my %h = (
        home     => '/',
        new      => '/new_document',
        edit     => '/edit',
        create   => '/create',
        search   => '/search',
        update   => '/update',
        summary  => '/summary',
        all_docs => '/all_docs',
        document => '/id',
    ); # need to have unique token name across all route files, so using prefix as a key
    $tokens->{uri_for_section}->{$PREFIX}->{$_}
        = uri_for('/'. $PREFIX . $h{$_}) for keys %h; # p $tokens;
}; 

=begin # rules for route names & uri_for_route:
cannot use method 'any' with route names: "Route with this name ($name) already exists"
   probably when route name is registered for GET, then for POST/HEAD/etc
cannot use uri_for_route in any template loaded after forward (data is deleted)
=cut

# these routes need unique (to DocsLib app) route-names (for redirect):
get  infolib_home       =>  '/' => needs login  => \&home;
get  infolib_document   => '/id/:id[Int]'       => \&get_document;
# these routes need permissions:
get  '/edit/:id[Int]'   => needs admin => \&edit_document;
post '/create'          => needs login => \&create_document;
post '/update/:id[Int]' => needs login => \&update_document;
# these routes don't need names or permissions
get '/new_document' => \&new_document;                           
get '/summary'      => \&summary;
get '/all_docs'     => \&all_documents;
post '/search'      => \&search;

#===============================================================================

sub flash { deferred @_ }

sub home { template home => { title => 'InfoLib' } }

sub new_document {
    var next_route => 'create';
    template $PREFIX.'/record.tt', { prefix => $PREFIX }
}

sub get_document {
    my $id = route_parameters->get('id'); # debug $id;
    my $rec = model->infolib->get_document_by_id($id); # p $rec; # AoH
    vars->{next_route} ||= 'edit/'.$id; # may already be set by edit_document()
    template $PREFIX.'/record.tt', { entry => $rec }; # href, not aref
}

sub edit_document {
    my $id = route_parameters->get('id');
    var next_route => 'update/'.$id;
    forward '/'.$PREFIX.'/id/'.$id;
}

sub create_document {
    my $params = request->parameters->as_hashref; # p $params;
    my $res    = model->infolib->save_document($params); # p $res;
	if ( $res->{error} ) {
		var input_error => $res->{error};
        template $PREFIX.'/record.tt', { entry => $params };
    }
	else {
        my $action = $params->{id} ? 'update_success' : 'input_success'; # update if id supplied
		flash ( $action => 1 ); # doesn't need message
		redirect uri_for_route( 'infolib_document', { id => $res->{id} } );
	}
}

sub update_document { # just captures document_id & forwards:
	forward '/'.$PREFIX.'/create', { id => route_parameters->get('id') };
}
    
sub search {
	my $str = body_parameters->get('search'); # =~ s{\s+}{}gr; # sometimes need space
	my $rec = model->infolib->find_documents($str); # p $rec; # AoH
	template $PREFIX.'/summary.tt', { records => $rec };
}

sub summary {
    my $rec = model->infolib->get_all_documents; # p $rec; # AoH
    template $PREFIX.'/summary.tt',  { records => $rec };
}

true;