package App::TT::Utils;

# doesn't work as a Feature::Compat::Class package

use strict;
use warnings;

use base 'Template::Plugin';
use Data::Printer;

sub new {
    my ($class, $context) = @_;
    return bless { _CONTEXT => $context }, $class;
}

# --- Define helpers below ---

sub is_between {
    my ($self, $val, $min, $max) = @_; # p $val; p $min; p $max;
    return ($val >= $min && $val <= $max) ? 1 : 0;
}

sub is_even {
    my ($self, $val) = @_;
    return ($val % 2 == 0);
}

sub is_odd {
    my ($self, $val) = @_;
    return ($val % 2 != 0);
}

=begin
clamp() returns $val limited to the interval [$min, $max]. If $val < $min it 
returns $min; if $val > $max it returns $max; otherwise it returns $val unchanged.
"Clamp" is the standard name in many languages and libraries for forcing a value
to lie within bounds. It “clamps” the value to the nearest limit when it would 
otherwise fall outside the allowed range.
=cut
sub clamp {
    my ($self, $val, $min, $max) = @_;
    return $min if $val < $min;
    return $max if $val > $max;
    return $val;
}

1;
