=begin 
  cannot use Feature::Compat::Class, it cannot find DBIx::Simple::Result
  despite using BEGIN block in multiple locations throughout app; from copilot
  chat: You cannot use Feature::Compat::Class directly for the result class if
  DBIx::Simple::Result is not a real module file, so use traditional package
  syntax for the result class.
- `class ... :isa(...)` requires the parent to be a real, loadable module file.
- `DBIx::Simple::Result` is not a real file, so `class ... :isa(DBIx::Simple::Result)` fails.

# use App::Class;
# class App::DB::Result :isa('DBIx::Simple::Result');
=cut

package App::DB::Result; # don't use 'class' syntax, see above

#================================================================================
# new methods row(), column(), value()
#================================================================================

BEGIN { # fix for DBIx::Simple::Result being in same file as DBIx::Simple & not in @INC:
    require DBIx::Simple; # warn $INC{'DBIx/Simple.pm'};
    $INC{'DBIx/Simple/Result.pm'} = $INC{'DBIx/Simple.pm'};
}
use parent 'DBIx::Simple::Result';

# single value:
sub value { my $val = shift->SUPER::list(@_); return $val } # list in scalar context
# more obvious name for 'list', returns array in list context, arrayref in scalar context:
sub row { 
    my @row = shift->SUPER::list(@_); 
    return wantarray ? @row : \@row;
}
# more obvious name for 'flat' (can't use 'list'), returns arrayref in scalar
# context and array in list context:
sub column { shift->SUPER::flat(@_) }

1;