#!/home/raj/.plenv/shims/perl
use 5.34.0;

#======================================================================================
# carmel install && carmel rollout to provide required libs in ../local/perl5
#======================================================================================

# starts a plackup -E deployment --workers=1 -a bin/app.psgi process on port 5003
# to start service at boot: sudo update-rc.d docslib defaults
# see below for init.d text

use Daemon::Control;
#use Plack::Runner; # only needed if using direct in program sub
use Data::Printer;
use Devel::Confess 'color';

use FindBin qw($Bin);  # load AFTER local::lib Carp or FindBin loads system Carp
use lib $Bin.'/../local/lib/perl5';

# in case app needs any Local:: libs
# $ENV{PERL5LIB} = '/home/raj/perl-lib'; # not required

my $GROUP  = $ENV{APP_GROUP} || die 'no APP_GROUP env var set'; # warn $GROUP;
my $USER   = $ENV{APP_USER}  || die 'no APP_USER env var set';  # warn $USER;

my $run_dir  = '/var/run/docslib'; # location of pid file & stderr
my $pid_file = $run_dir . '/docslib.pid';

my $app_home = '/home/raj/apps/DocsLibrary';
my $program  = 'plackup';
my $stdout   = $app_home . '/logs/deployment.log';
my $stderr 	 = $stdout; # combined
my $workers  = 1;
my $port     = 5003;
my $name     = 'DocsLibrary';
my $app      = $app_home . '/bin/app.psgi'; # p $app;

my @program_args = (
#	-s => 'Gazelle', # not required for this app
	-a => $app,
	-p => $port,
	-E => 'deployment', # tells dancer app which env & logs to use
	'--workers' => $workers,
);

my %h = (
    name         => $name,
#    lsb_start   => '$syslog $remote_fs',
#    lsb_stop    => '$syslog',
    lsb_sdesc    => $name,
    lsb_desc     => $name,
    path         => $0, # this script
    program      => \&run,

    pid_file     => $pid_file,
    stderr_file  => $stderr,
    stdout_file  => $stdout,

	user         => $USER,
    group        => $GROUP,
    fork         => 2,
); # warn Dumper \%args;

Daemon::Control->new(\%h)->run;

sub run {
    # set PERL5LIB otherwise it can't find Plack::Runner (and probably others)
    $ENV{PERL5LIB} = "${app_home}/local/lib/perl5";
    # added by VSC co-pilot after ZBOX deployment failed to find templates
    chdir $app_home or die "chdir $app_home failed: $!";

    exec($program, @program_args);
}

__END__
### /etc/init.d/docslib ==========================================================
#!/bin/sh

### BEGIN INIT INFO
# Provides: 		 DocsLibrary
# Required-Start:
# Required-Stop:
# Default-Start: 	 2 3 4 5
# Default-Stop: 	 0 1 6
# Short-Description: DocsLibrary daemon
# Description: 		 Controls the DocsLibrary daemon script
### END INIT INFO

export APP_USER=raj
export APP_GROUP=raj

# export PERL5LIB=/home/raj/perl-lib # better to explicitly set if needed

# don't need this if using Plack::Runner in $SCRIPT:
#export PATH=/home/raj/.plenv/shims:$PATH

SCRIPT=/home/raj/apps/DocsLibrary/bin/daemon-control.pl
if [ -x $SCRIPT ];
then
    $SCRIPT $@
else
    echo "Required program $SCRIPT not found!"
    exit 1;
fi

### lighttpd config (conf-available/20-proxy.conf) =============================
$HTTP["host"] =~ "docslib.zbox.lan$" {
    server.document-root = "/home/raj/apps/DocsLibrary/public/"
    proxy.server = (
        "" => (
            (
                "host" => "127.0.0.1", "port" => 5003,
                #"host" => "/tmp/docslib.sock",
                "check-local" => "disable",
            )
        )
    )
}

* in /etc/lighttpd/lighttpd.conf:
  server.modules += ( "mod_accesslog" ) # just ensure it's in the list
  accesslog.filename = "/var/log/lighttpd/access.log"

* for local lan using PiHole DNS, register a local DNS domain/IP combination eg
  docslib.zbox.lan   192.168.1.112
