use App::Class; # Import::Into

class App::Model {
    use App::DB;

	use FindBin qw($RealBin); # warn $RealBin;
    use Crypt::PBKDF2;
    use Data::Printer;
	use Path::Tiny;
	use Git;

	my $git = Git->repository(
		Directory => path($RealBin, '..', '.git')->realpath );

    field $cfg :reader :param; # p $cfg;
    field $db  :reader = App::DB->new( cfg => $cfg ); # dsl => $dsl

	method find_user ($username) { $db->find_user($username) }

    method verify_password ($pwd, $hash) {
        Crypt::PBKDF2->new->validate($hash, $pwd); # using defaults for new()
    }

    method get_document ($id) {
        my $result = $self->db->get_document($id); # p $result;
        return $result;
    }

	method save_document ($data) {
		my $result = $self->db->save_document($data); # p $result;
        return $result;
	}

    method find_documents ($str) {
 		my $result = $self->db->find_documents($str); # p $result;
        return $result;
    }
	
	method version {
		sprintf '%s [%s]',
			$git->command_oneline( 'rev-list', qw/HEAD --no-merges --count/ ),
			$git->command_oneline( 'log', qw/-1 --no-merges --pretty=format:%h/ ); # commit hash
	}

	method gitlog {
		my @args = ('--pretty=format:"%ad :: %s"', qw/--no-merges --date=relative/);
		my @log  = $git->command( 'log', @args ); # warn Dumper \@log;
		return \@log;
	}
}
