# https://github.com/PerlDancer/Dancer2/blob/docs/doc-rewrite-grant/lib/Dancer2/Manual/Tutorial.pod

BEGIN { # set test env otherwise get development config settings - unless explicitly
    # set at command-line: "DANCER_ENVIRONMENT=development prove -lv t/"
    $ENV{DANCER_ENVIRONMENT} ||= $ENV{PLACK_ENV} ||= 'test';
}

use strict;
use warnings;

use Test::More;
use Data::Printer;
use Test::WWW::Mechanize::PSGI;

use DocsLib;
my $cfg  = DocsLib->dancer_app->settings; # p $cfg; exit;
my $mech = Test::WWW::Mechanize::PSGI->new(
    app => DocsLib->to_app,
);

my $user = $cfg->{user}; # p $user;
my $username = $user->{name};
my $password = $user->{plain_text_pwd}
    || die qq!require 'plain_text_pwd' setting in test_local.yml file!;

$mech->get_ok('/infolib/', 'Got / while not logged in');
$mech->content_contains('Password', '...and was presented with a login page');
$mech->submit_form_ok({
    fields => {
        username => $username,
        password => 'foobar',
    }}, '...which we gave invalid credentials'); # p $mech->content;
$mech->content_contains('Invalid login', '...and gave us an appropriate error');
$mech->submit_form_ok({
    fields => {
        username => $username,
        password => $password,
    }}, '...so we give it real credentials'); # print $mech->content;
$mech->content_contains('/new_document',
     '...and get something that looks like the new document form' );

done_testing(6);