use App::Class; # Import::Into

class App::Model {
    use Crypt::PBKDF2;
    use Data::Printer;
    use App::DB;

    field $dsl :reader :param; # Dancer2 DSL
    field $dbh :reader :param; # mandatory   # if using D2::Plugin::DB
	# field $cfg :reader :param; # mandatory # if using DBIx::Simple
    field $db :reader = App::DB->new( dbh => $dbh, dsl => $dsl );

	method find_user ($username) { $db->find_user($username) }

    method verify_password ($pwd, $hash) {
        Crypt::PBKDF2->new->validate($hash, $pwd); # using defaults for new()
    }

    method get_document ($id) {
        my $result = $self->db->get_document($id); # p $result;
        return $result;
    }

	method save_document ($data) {
		my $result = $self->db->save_document($data); # p $result;
        return $result;
	}

    method find_documents ($str) {
 		my $result = $self->db->find_documents($str); # p $result;
        return $result;
    }
}
