package Routes::Test;
use Dancer2 appname => 'DocsLib';

use v5.34.0;
use Data::Printer;

my $PREFIX = 'test'; 
prefix "/$PREFIX";

hook before_template_render => sub { };

get 'test_home'     => '/'             => \&home;
get 'htmx_fragment' => '/fragment'     => \&fragment;                     
get 'dump-headers'  => '/dump-headers' => \&dump_headers;

# Root page with a button that triggers an htmx request
sub home {
  return q~
    <!DOCTYPE html>
    <html>
    <head>
      <title>htmx Test</title>
      <script src="https://unpkg.com/htmx.org@1.9.10"></script>
    </head>
    <body>
      <button hx-get="/test/fragment" hx-target="#container" hx-swap="innerHTML">
        Load Fragment
      </button>
      <div id="container"></div>
    </body>
    </html>~;
}

# Endpoint that returns a simple fragment
sub fragment {
    my $headers = request->headers; # p $headers;
    my @wanted  = qw(
        hx-request
        hx-current-url
        hx-trigger
        hx-target
        hx-prompt
    );
    my $dump = join "\n",
      map { "$_: " . ($headers->header($_) // '[none]') } @wanted; # p $dump;

    return qq{
        <p>Hello from htmx fragment</p>
        <pre>$dump</pre>
    };
}

sub dump_headers {
    my $headers = request->headers;

    my $dump = join "\n",
      map { "$_: " . ($headers->header($_) // '') }
      $headers->header_field_names;

    return "<pre>$dump</pre>";
}