package Routes::DPW;
use Dancer2 appname => 'DocsLib';

use v5.34.0;
use Data::Printer;

use App::Model; # D2 plugin, provides 'model' keyword
use Path::Tiny;
use Dancer2::Plugin::Deferred;
use Dancer2::Plugin::Auth::Tiny;

my $PREFIX = 'dpw'; 
prefix "/$PREFIX";

# TODO: make this path( config->{documents_path}, $PREFIX );
my $docs_path = path( config->{documents_path}, 'household' ); # debug $docs_path;
# set path to documents folder:
model->household->set_docs_path($docs_path);

hook before => sub { };

hook before_template_render => sub {
    my $tokens = shift; # need to have unique token name across all route files 
	$tokens->{dpw_categories} = model->household->get_categories; # p $tokens;

    my %h = (
        home     => '/',
        new      => '/new_document',
        edit     => '/edit',
        create   => '/create',
        search   => '/search',
        update   => '/update',
        summary  => '/summary',
        document => '/id',
        download => '/download',
    );
    $tokens->{uri_for_section}->{$PREFIX}->{$_}
        = uri_for('/'. $PREFIX . $h{$_}) for keys %h; # p $tokens;
};

# cannot use method 'any' with route names: "Route with this name ($name) already exists"
#   probably when route name is registered for GET, then for POST/HEAD/etc
# cannot use uri_for_route in any template loaded after forward (data is deleted)
# these routes need (unique) route-names (for redirect):
get 'dpw_home'       => '/'
                     => needs login      => \&home; 
get 'get_dpw_entry'  => '/id/:id[Int]'   => \&get_document;
# these routes need permissions:
post '/create'          => needs login => \&create_document;
post '/edit/:id[Int]'   => needs admin => \&edit_document;
post '/update/:id[Int]' => needs login => \&update_document;
# these routes don't need names or permissions
get  '/new_document'           => \&new_document;
get  '/download/:category/:id' => \&download;
get  '/summary'                => \&summary;
post '/summary'                => \&summary; # with filter
post '/search'                 => \&search;

# ==============================================================================

sub flash { deferred @_ }

sub home { template home => { title => 'DPW Filing Cabinet' } }

sub new_document {
    var next_route => 'create';
    template $PREFIX.'/record.tt', { prefix => $PREFIX };
}

sub get_document {
    my $id = route_parameters->get('id');
    my $rec = model->household->get_document($id); # p $rec; # AoH
    vars->{next_route} ||= 'edit/'.$id; # may already be set by edit_document()
    template $PREFIX.'/record.tt', { entry => $rec };
}

sub edit_document {
	my $id = route_parameters->get('id');
    var next_route => 'update/'.$id;
    my $route = '/'.$PREFIX.'/id/'.$id;
	forward $route, {}, { method => 'GET' };
}

sub summary {
	my $category = body_parameters->get('category'); # warn $category; # optional
    my $rec = model->household->get_all_documents($category); # p $rec; # AoH
    template $PREFIX.'/summary.tt', { records => $rec };
}

sub search {
	my $str = body_parameters->get('search'); # =~ s{\s+}{}gr; # sometimes need space
	my $rec = model->household->find_documents($str); # p $rec; # AoH
    template $PREFIX.'/summary.tt', { records => $rec };
}

sub update_document { # just captures document_id & forwards:
	forward '/'.$PREFIX.'/create', { id => route_parameters->get('id') };
}

sub create_document {
    my $params = request->parameters->as_hashref; # p $params;
    # get upload data - new entry only, passed as param if edit:
    my $data_file = upload('filename'); # p $data_file;

	my $res = model->household->save_document($params, $data_file); # p $res;
	if ( $res->{error} ) {
		var input_error => $res->{error};
		template $PREFIX.'/record.tt', { entry => $params };
    }
	else { # p $params; debug $docs_path;
        my $action = $params->{id} ? 'update_success' : 'input_success'; # update if id supplied
		flash ( $action => 1 ); # doesn't need message
        if ($data_file) { # upload file to docs dir if uploaded:
			# _upload_dir set in model _check_filepath() method:
            my $filepath = path( @{ $params }{ qw/_upload_dir filename/ } ); # p $filepath;
			$data_file->copy_to( $filepath );
		}
		redirect uri_for_route( 'get_dpw_entry', { id => $res->{id} } );
	}
}

sub download {
    my $category = route_parameters->get('category');
    my $document = route_parameters->get('id');
    my $dir = Path::Tiny->new( join '/', $docs_path, $category );
    # normalize to absolute path unless already:
    $dir = $dir->absolute( config->{appdir} ) unless $dir->is_absolute;

    my $file = $dir->child($document); debug "Resolved file path: $file";
    -e $file or send_error 'File not found', 404;

    send_file $file->stringify, system_path => 1;
}

true;