package App::Model; # a D2 plugin, provides 'model' keyword

use 5.34.0;
use App::DB;
use Model::Core;
use Data::Printer;
use Dancer2::Plugin;

#plugin_keywords
#    model => { $_[0]->model_core }; # for use if separate 'has' eg has model_core

has db => (
    is => 'lazy',
    # handles => [ 'check_db_connection' ], # to check db handle still connected
    builder => sub { App::DB->new( cfg => shift->app->config ) },
);

has model  => (
    is => 'lazy',
    # handles => [ 'check_db_connection' ], # to check db handle still connected
    plugin_keyword => 1,  # keyword will be 'model'
);
sub _build_model {
    my $plugin = shift; # p $plugin->app->config;
    my %args = (
        #session => $plugin->app->session, # not needed ?
        cfg  => $plugin->app->config,
        db   => $plugin->db,
    );
    Model::Core->new(%args);
    # my $m = Model::Core->new(%args); # p $m; return $m;
}

sub BUILD {
    my $plugin = shift; # p ref $plugin; 'Model' ie self
    # nothing needed here
};

1;