=begin # cannot use Feature::Compat::Class, it cannot find DBIx::Simple::Result
  despite using BEGIN block in multiple locations throughout app 
# use App::Class;
# class App::DB::Result :isa('DBIx::Simple::Result');
=cut

package App::DB::Result; # don't use 'class' syntax, see above

=begin # README - this does not work, functions are inaccessible via DBIx::Simple::Result
================================================================================
* new methods row(), column(), value()
================================================================================
=cut

BEGIN { # fix for DBIx::Simple::Result being in same file as DBIx::Simple & not in @INC:
    require DBIx::Simple; # warn $INC{'DBIx/Simple.pm'};
    $INC{'DBIx/Simple/Result.pm'} = $INC{'DBIx/Simple.pm'};
}
use parent 'DBIx::Simple::Result';

# method column { shift->SUPER::flat(@_) } # this is not accessible through ::Result
sub column { shift->SUPER::flat(@_) } # this is not accessible through ::Result

1;