package App::Class;

use 5.24.0;
use strict;
use warnings;
use feature ();

use Import::Into;

sub import {
	my ($class) = @_;

	my $caller = caller;

	warnings->import;
	warnings->unimport('experimental::signatures');
	strict->import;
	feature->import(qw/signatures :5.24/); # say (signatures in 5.36)
	Feature::Compat::Class->import::into($caller); # lacks roles & writer
	# Object::Pad->import::into($caller); # provides roles & writer
	Feature::Compat::Try->import::into($caller); 
}

sub unimport {
	warnings->unimport;
	feature->unimport;
	strict->unimport;
}

1;