# script to test re-throwing die:
use 5.34.0;

use Data::Printer;
use Feature::Compat::Try;
use feature 'signatures'; no warnings 'experimental';

my $res = save_document ( { category => 'foo' } ); p $res;

sub save_document ($params) {
    my $result = do { # choice is to capture error, or just die with db error
        try {         #  since user probably cannot do anything about it
			my $new_dir = _move_file($params); say "new_dir: $new_dir";
            return { id => 1 };
        }
        catch ($e) { # dsl->warning $e; # can't do it
            return { error => $e };
        }
    };
	return $result;
}

sub _move_file ($params) { # p $params;
    my $new_dir = do {
        try {
            _check_filepath( $params->{category} ); # p $new_dir;
        }
        catch ($e) {
            warn "_move_file() caught: $e";
            die $e; # rethrow error from _check_filepath()
        };
    };
	warn '####'; # don't get this far if $e caught
	return $new_dir;
}

sub _check_filepath ($category)  {
	#return $category; ####### comment this to throw error
    die qq!file "filename" already exists\n!;
}

