use App::Class; # Import::Into

class App::DB {
	use Data::Printer;
	use DBIx::Simple;
	use File::Slurper 'read_text';

	field $cfg  :reader :param; # mandatory
    field $dbix :reader =
		DBIx::Simple->connect( 'dbi:SQLite:dbname='.$cfg->{dbname} );
    # field $dsl  :reader :param; # mandatory
	ADJUST { # p $cfg->{db_init}, as => "db_init file:";
		my $dbi_trace_level = $ENV{DBI_TRACE} || 0;
		$dbix->dbh->trace('SQL|'.$dbi_trace_level);
		# init db if 1st run (creates db also if not exists)
		my $schema = read_text( $cfg->{db_init} );  # p $sql;
		# my @schema = split /\n\s*\n/, $sql;    # p @schema;
		# $dbix->dbh->do($_) for @schema; # not needed, can run directly
		$dbix->dbh->do($schema);
	}
    # timestamp is GMT, needs to be converted to local timezone:
    my $cols = q!id, title, keywords, content, DATETIME(time, 'localtime') !
			. 'as time';

	method find_user ($username) { # p $dbh->{Name}; p $username;
        my $user = $dbix->select('users', '*', { username => $username })->hash; # p $user;
        return $user;
    }

	method save_document ($data) { # p $data; # return;
		my @cols = qw(id title keywords content);
		my $flds = join ',', @cols;
		my $sql  = qq!INSERT INTO library($flds) VALUES(?,?,?,?) ON CONFLICT(id)
			 DO UPDATE SET title = ?, keywords = ?, content = ?!; # p $sql;
		my @bind = ( @{$data}{@cols}, @{$data}{ qw/title keywords content/ });

        my $result = do { # choice is to capture error, or just die with db error
            try {         #  since user probably cannot do anything about it
                $dbix->query( $sql, @bind ) or die $dbix->error;
				# record id = $data->{id} from record edit, or get last insert:
				my $id = $data->{id} || $dbix->last_insert_id(); # p $id;
                return { id => $id };
            }
            catch ($e) { # dsl->warning $e; # can't do it
                return { error => $e };
            }
        };
        return $result;
    }

	method get_document ($id) {
		my $rec = $dbix->select( 'library', $cols, { id => $id } )->hashes; # p $rec;
		return $rec; # returns AoH for template
	}

	method find_documents ($str) {
		my %condition = ( -regexp => $str );
		my %where = (
			-or => [
				title    => \%condition,
				keywords => \%condition,
				content  => \%condition,
			]
		);
		my $res = $dbix->select( 'library', $cols, \%where )->hashes; # p $res;
		return $res;
	}
 }