use strict;
use warnings;

use Test::More;
use Plack::Test;
use HTTP::Request::Common;
use Ref::Util qw<is_coderef>;

# use AppTest; # load 1st to set DANCER_ENVIRONMENT env - for Model::DB::debug
use DocsLib;

my $app = DocsLib->to_app;
ok( is_coderef($app), 'Got app' );

my $test = Plack::Test->create($app);
{
    my $res = $test->request( GET '/infolib/' );
    ok( $res->is_redirect, '[GET /] redirect' );
}
{
    my $res = $test->request( GET '/login' ); # warn $res->content;
    ok( $res->is_success, '[GET /login] successful' );
}

done_testing;