package Routes::InfoLibrary;
use Dancer2 appname => 'DocsLib';

use v5.34.0;
use Data::Printer;
use Data::Dumper;

use App::Model; # D2 plugin, provides 'model' keyword
use Dancer2::Plugin::Deferred;
use Dancer2::Plugin::Auth::Tiny;

my $PREFIX = 'infolib'; 
prefix "/$PREFIX";

hook before_template_render => sub { 
    my $tokens = shift; # need to have unique token name across all route files 
    my %h = (
        home     => '/' . $PREFIX . '/',
        new      => '/' . $PREFIX . '/new_document',
        edit     => '/' . $PREFIX . '/edit',
        search   => '/' . $PREFIX . '/search',
        update   => '/' . $PREFIX . '/update',
        summary  => '/' . $PREFIX . '/summary',
        all_docs => '/' . $PREFIX . '/all_docs',
        document => '/' . $PREFIX . '/id',
    );
    $tokens->{uri_for_section}->{$PREFIX}->{$_} = uri_for($h{$_}) for keys %h; # p $tokens;
}; 

# cannot use method 'any' with route names: "Route with this name ($name) already exists"
#   probably when route name is registered for GET, then for POST/HEAD/etc
# cannot use uri_for_route in any template loaded after forward (data is deleted)
get  'infolib_home'            => '/'
                               => needs login => \&home; 
post 'new_infolib_document'    => '/new_document'
                               => needs login => \&new_document;
post 'edit_infolib_document'   => '/edit/:id[Int]'
                               => needs login => \&edit_document;
post 'update_infolib_document' => '/update/:id[Int]'
                               => needs login => \&update_document;

get  'infolib_summary'       => '/summary'     => \&summary;
get  'get_infolib_document'  => '/id/:id[Int]' => \&get_document;
get  'all_info_documents'    => '/all_docs'    => \&all_documents;
post 'find_info_documents'   => '/search'      => \&search;

#===============================================================================

sub flash { deferred @_ }

sub home {
    template $PREFIX.'/home.tt', { records => query_parameters->get('records') };
};

sub get_document {
    my $id = route_parameters->get('id');
    my $rec = model->infolib->get_document($id); # p $rec; # AoH
    template $PREFIX.'/home.tt', { records => $rec };
};

sub search {
	my $str = body_parameters->get('search') =~ s{\s+}{}gr;
	my $rec = model->infolib->find_documents($str); # p $rec; # AoH
    my $tt = @$rec ? 'summary.tt' : 'home.tt';
	template path( $PREFIX, $tt ),  { records => $rec };
};

sub edit_document {
	var is_edit => 1;
    my $route = '/'.$PREFIX.'/id/'.route_parameters->get('id');
	forward $route, {}, { method => 'GET' };
};

sub new_document {
    my $params = request->parameters->as_hashref; # p $params;
    my $res    = model->infolib->save_document($params); # p $res;
	if ( $res->{error} ) {
		var input_error => $res->{error};
		forward '/'.$PREFIX.'/', { records => [ $params ] }, { method => 'GET' }; # tt needs AoH
    }
	else {
		flash ( input_success => 1 ); # doesn't need message
		redirect uri_for_route( 'get_infolib_document', { id => $res->{id} } );
	}
};

sub update_document { # just captures document_id & forwards:
	forward '/'.$PREFIX.'/new_document', { id => route_parameters->get('id') };
};
    
sub all_documents {
	my $rec = model->infolib->get_all_documents; # p $rec; # AoH
	template $PREFIX.'/home.tt', { records => $rec };
};

sub summary {
    my $rec = model->infolib->get_all_documents; # p $rec; # AoH
    template $PREFIX.'/summary.tt',  => { records => $rec };
};

true;