package Routes::DPW;
use Dancer2 appname => 'DocsLib';

use v5.34.0;
use Data::Printer;

use App::Model; # D2 plugin, provides 'model' keyword
use Dancer2::Plugin::Deferred;
use Dancer2::Plugin::Auth::Tiny;

my $PREFIX = 'dpw'; 
prefix "/$PREFIX";

my $docs_path = path( config->{documents_path}, 'household' ); # debug $docs_path;
# set path to documents folder:
model->household->set_docs_path($docs_path);

hook before_template_render => sub {
    my $tokens = shift; # need to have unique token name across all route files 
	$tokens->{dpw_categories} = model->household->get_categories; # p $tokens;

    my %h = (
        home     => '/' . $PREFIX . '/',
        new      => '/' . $PREFIX . '/new_document',
        edit     => '/' . $PREFIX . '/edit',
        search   => '/' . $PREFIX . '/search',
        update   => '/' . $PREFIX . '/update',
        summary  => '/' . $PREFIX . '/summary',
        all_docs => '/' . $PREFIX . '/all_docs',
        document => '/' . $PREFIX . '/id',
        download => '/' . $PREFIX . '/download',
    );
    $tokens->{uri_for_section}->{$PREFIX}->{$_} = uri_for($h{$_}) for keys %h; # p $tokens;
};

# cannot use method 'any' with route names: "Route with this name ($name) already exists"
#   probably when route name is registered for GET, then for POST/HEAD/etc
# cannot use uri_for_route in any template loaded after forward (data is deleted)
get  'dpw_home'            => '/'
                           => needs login => \&home; 
post 'edit_dpw_entry_post' => '/edit/:id[Int]'
                           => needs login => \&edit_document;
get  'edit_dpw_entry_get'  => '/edit/:id[Int]' # required for GET request, needs unique route name
                           => needs login => \&edit_document;
post 'new_dpw_entry'       => '/new_document'
                           => needs login => \&new_document;
post 'update_dpw_entry'    => '/update/:id[Int]'
                           => needs login => \&update_document;

get  'dpw_summary'            => '/summary'                => \&summary;
get  'download_dpw_document'  => '/download/:category/:id' => \&download;
get  'get_dpw_entry'          => '/id/:id[Int]'            => \&get_document;
get  'all_dpw_entries'        => '/all_docs'               => \&all_documents;
post 'find_dpw_entries'       => '/search'                 => \&search;
post 'dpw_summary_filter'     => '/summary'                => \&summary;

sub flash { deferred @_ }

sub home {
    template $PREFIX.'/home.tt', { records => query_parameters->get('records') };
};

sub get_document {
    my $id = route_parameters->get('id');
    my $rec = model->household->get_document($id); # p $rec; # AoH
    template $PREFIX.'/home.tt', { records => $rec };
};

sub all_documents {
	my $rec = model->household->get_all_documents; # p $rec; # AoH
	template $PREFIX.'/home.tt', { records => $rec };
};

sub summary {
	my $category = body_parameters->get('category'); # optional
    my $rec = model->household->get_all_documents($category); # p $rec; # AoH
    template $PREFIX.'/summary.tt',  => { records => $rec };
};

sub search {
	my $str = body_parameters->get('search') =~ s{\s+}{}gr;
	my $rec = model->household->find_documents($str); # p $rec; # AoH
    my $tt = @$rec ? 'summary.tt' : 'home.tt';
	template path( $PREFIX, $tt ),  { records => $rec };
};

sub edit_document {
	var is_edit => 1;
    my $route = '/'.$PREFIX.'/id/'.route_parameters->get('id');
	forward $route, {}, { method => 'GET' };
};

sub update_document { # just captures document_id & forwards:
	forward '/'.$PREFIX.'/new_document', { id => route_parameters->get('id') };
};

sub new_document {
    my $params = request->parameters->as_hashref; # p $params;
    # get upload data - new entry only, passed as param if edit:
    my $data_file = upload('filename'); # p $data_file;

	my $res = model->household->save_document($params, $data_file);
	if ( $res->{error} ) {
		var input_error => $res->{error};
		forward '/'.$PREFIX.'/', { records => [$params] }, { method => 'GET' };
    }
	else {
		flash ( input_success => 1 ); # doesn't need message
        if ($data_file) { # upload file to docs dir if uploaded:
			my $filepath = path($docs_path, @{$params}{ qw/category filename/ });
			$data_file->copy_to( $filepath );
		}
		redirect uri_for_route( 'get_dpw_entry', { id => $res->{id} } );
	}
};

sub download {
    my $category = route_parameters->get('category');
    my $document = route_parameters->get('id');
    my $file = join '/', $docs_path, $category, $document; # debug $file;
    send_file $file, system_path => 1;
};

true;