use App::Class; # Import::Into

class Model::Core;
=begin
can also config as roles, need to import Object::Pad instead of Feature::Compat::Class
and define "role Model::Infolibrary" instead of "class Mode::InfoLibrary", but role
methods need to have unique names
class Model::Core
#	:does(Model::InfoLibrary)
#	:does(Model::Moongate)
#	:does(Model::DPW);
=cut

use Module::List::Pluggable 'import_modules'; # import all Model::<class>
import_modules( 'Model', { exceptions => ['Core'] } ); # except itself

use Crypt::PBKDF2;
use Data::Printer;
use FindBin qw($RealBin);
use Git::Wrapper;

my $git = Git::Wrapper->new($RealBin);

field $cfg :reader :param; # p $cfg;
field $db  :reader :param; # App::DB (DBIx::Simple object)

field $infolib   :reader = Model::InfoLibrary->new( dbix => $db->dbix );
field $moongate  :reader = Model::Moongate->new( dbix => $db->dbix );
field $household :reader = Model::DPW->new( dbix => $db->dbix );

method find_user ($username) { $db->find_user($username) }

method verify_password ($pwd, $hash) {
    Crypt::PBKDF2->new->validate($hash, $pwd); # using defaults for new()
}

method app_version { return $git->log } # size of log

method total_count ($table) { $db->total_count($table) } 

method gitlog { # using Git::Wrapper;
	my $n = $git->log; # say $n; # log() as scalar returns no. of log entries

	my @args  = qw( --no-merges --date=relative );
	my @dates = $git->RUN( qw/log --pretty=format:%ad/, @args);   # p @dates;
	my @msgs  = $git->RUN( qw/log --pretty=format:%s/,  $args[0]); # p @msgs;

	my @log = map { date => $dates[$_], msg => $msgs[$_] }, 0 .. $n - 1; # p @log;
	return \@log;
}
=begin
method gitlog { # using Git
	my @args = ('--pretty=format:%ad :: %s', qw/--no-merges --date=relative/);
	my @log  = $git->command( 'log', @args ); # warn Dumper \@log;
	return \@log;
}
=cut

1;