package App::LogAnyAdapter;

# from ChatGPT session - see documents/LAA-ChatGPT.txt

use 5.34.0;

# this is from ChatGPPT session but function works OK without it:
# use Dancer2 ();          # load but don’t import the DSL
use Log::Any::Adapter;
use Data::Printer;
use App::Class;

=begin # passing log-level from D2 app now
my %level_for = (
    development => 'debug',
    production  => 'warning',
    test        => 'info',
);
my $env = Dancer2->runner->environment; warn "env:$env";
my $log_level = $level_for{$env};   warn "min_log_level:$min_log_level";
=cut

# Callback is deprecated, use Capture instead (doesn't work for tests)
sub init ($log_level) { # warn $log_level;
    # Log::Any does not recognise 'core' as valid setting, trace is 'lowest':
    $log_level = 'trace' if $log_level eq 'core'; # warn $log_level;
    Log::Any::Adapter->set(
        Callback => (
            min_level  => $log_level, # passed from D2 app, or find a way of getting it here
            logging_cb => sub {
                my ($method, $self, $format, @params) = @_;
                my $msg = @params ? sprintf($format, @params) : $format;
                # Get the first registered app (single-app setup)
                my ($app) = @{ Dancer2->runner->apps } or return;  # warn 'here';
                # Skip Log::Any frames so the caller is your model code
                my (undef, $file, $line) = caller(3);

                $app->logger_engine->log(
                    $method => $msg,
                    caller  => [$file, $line],
                );
            },
        ),
    );
}

1;