use App::Class; # Import::Into

class App::Model {
    use App::DB;

	use FindBin qw($RealBin); # warn $RealBin;
    use Crypt::PBKDF2;
    use Data::Printer;
	use Git::Wrapper;
	use Path::Tiny;

	my $git = Git::Wrapper->new($RealBin);

    field $cfg :reader :param; # p $cfg;
    field $db  :reader = App::DB->new( cfg => $cfg );

	method find_user ($username) { $db->find_user($username) }

    method verify_password ($pwd, $hash) {
        Crypt::PBKDF2->new->validate($hash, $pwd); # using defaults for new()
    }

    method get_document ($id) {
        my $result = $self->db->get_document($id); # p $result;
        return $result;
    }

	method save_document ($data) {
		my $result = $self->db->save_document($data); # p $result;
        return $result;
	}

    method find_documents ($str) {
 		my $result = $self->db->find_documents($str); # p $result;
        return $result;
    }

    method app_version { return $git->log } # size of log

	method gitlog { # using Git::Wrapper;
		my $log_count = $git->log; # say $log_count;

		my @dates = $git->RUN('log', '--pretty=format:%ad', qw/--no-merges --date=relative/); # p @dates;
		my @msgs  = $git->RUN('log', '--pretty=format:%s', qw/--no-merges/); # p @msgs;

		my @log = map { date => $dates[$_], msg => $msgs[$_] }, 
			0 .. $log_count - 1; # p @log;
		return \@log;
	}
=begin
	method gitlog { # using Git
		my @args = ('--pretty=format:%ad :: %s', qw/--no-merges --date=relative/);
		my @log  = $git->command( 'log', @args ); # warn Dumper \@log;
		return \@log;
	}
=cut
}
