package App::Test;

use App::Class;
use Exporter 'import';
use HTML::TreeBuilder;
use HTTP::Request::Common;

our @EXPORT = qw( process_request get_next_location );

my $t; # set in initialise()

# not exported, needs to be called as App::Test::initialise ($jar, $test)
sub initialise ($jar, $test) {
    $t->{cookie_jar} = $jar;
    $t->{plack_test} = $test;
}

sub process_request ($req) {
	$t->{cookie_jar}->add_cookie_header($req);
    my $res = $t->{plack_test}->request($req);
    $t->{cookie_jar}->extract_cookies($res);
    return $res;
}

sub get_next_location ($res) {
    my $location = $res->header('Location');
    my $next_url = GET $location;
    my $next_res = process_request($next_url);
    return $next_res;
}

# not exported, needs to be called as App::Test::html2txt($res)
sub html2txt ($res) {
    my $tree = HTML::TreeBuilder->new_from_content($res->decoded_content);
    return $tree->as_text;
}

1;