use App::Class; # Import::Into

class App::DB {
	use Data::Printer;
	use DBIx::Simple;
	use File::Slurper 'read_text';

    # our $DBNAME; # in case we need direct access to db name (eg DBIx::Simple)

	field $cfg  :reader :param; # mandatory
    field $dbix :reader =
		DBIx::Simple->connect( 'dbi:SQLite:dbname='.$cfg->{dbname} );
    field $dsl  :reader :param; # mandatory
	ADJUST { # p $cfg->{db_init}, as => "db_init file:";
		my $dbi_trace_level = $ENV{DBI_TRACE} || 0;
		$dbix->dbh->trace('SQL|'.$dbi_trace_level);
		# init db if 1st run (creates db also if not exists)
		# need a horrible hack for sqlite which can only execute 1 stmt at a time:
		my $sql = read_text( $cfg->{db_init} );  # p $sql;
		my @schema = split /\n\s*\n/, $sql;      # p @schema;
		$dbix->dbh->do($_) for @schema;
	}

	method find_user ($username) { # p $dbh->{Name}; p $username;
        my $user = $dbix->select( 'users', '*', { username => $username } )->hash; # p $user;
        return $user;
    }

	method save_document ($data) { # p $data; # return;
        my $result = do { # choice is to capture error, or just die with db error
            try {         #  since user probably cannot do anything about it
				$dbix->insert( library => $data );
				my $id = $dbix->last_insert_id; # p $id;
                return { id => $id };
            }
            catch ($e) { # dsl->warning $e; # can't do it
                return { error => $e };
            }
        };
        return $result;
    }

	method get_document ($id) {
		my $rec = $dbix->select( 'library', '*', { id => $id } )->hashes; # p $rec;
		return $rec; # returns AoH for template
	}

	method find_documents ($str) {
		my %condition = ( -regexp => $str );
		my %where = (
			-or => [
				title    => \%condition,
				keywords => \%condition,
				content  => \%condition,
			]
		);
		my $res = $dbix->select( 'library', '*', \%where)->hashes; # p $res;
		return $res;
	}
 }