use App::Class; # Import::Into

class App::Model {
    use App::DB;

	use FindBin qw($RealBin); # warn $RealBin;
    use Crypt::PBKDF2;
    use Data::Printer;
	use Git::Wrapper;
	use Path::Tiny;

	my $git = Git::Wrapper->new($RealBin);

    field $cfg :reader :param; # p $cfg;
    field $db  :reader = App::DB->new( cfg => $cfg );

	method find_user ($username) { $db->find_user($username) }

    method verify_password ($pwd, $hash) {
        Crypt::PBKDF2->new->validate($hash, $pwd); # using defaults for new()
    }

    method get_document ($id) {
        my $result = $self->db->get_document($id); # p $result;
        return $result;
    }

    method save_document ($data) {
		my $result = $self->db->save_document($data); # p $result;
        return $result;
    }

    method find_documents ($str) {
 		my $result = $self->db->find_documents($str); # p $result;
        return $result;
    }

	method get_all { $self->db->get_all }

	method total_count { $self->db->total_count }

    method app_version { return $git->log } # size of log

	method gitlog { # using Git::Wrapper;
		my $n = $git->log; # say $n; # log() as scalar returns no. of log entries

		my @args  = qw( --no-merges --date=relative );
		my @dates = $git->RUN( qw/log --pretty=format:%ad/, @args);   # p @dates;
		my @msgs  = $git->RUN( qw/log --pretty=format:%s/,  $args[0]); # p @msgs;

		my @log = map { date => $dates[$_], msg => $msgs[$_] }, 0 .. $n - 1; # p @log;
		return \@log;
	}
=begin
	method gitlog { # using Git
		my @args = ('--pretty=format:%ad :: %s', qw/--no-merges --date=relative/);
		my @log  = $git->command( 'log', @args ); # warn Dumper \@log;
		return \@log;
	}
=cut
}
