  document.getElementById('dump-to-file').addEventListener('click', () => {
    // Capture the entire *current* DOM (including htmx swaps)
    const html = document.documentElement.outerHTML;

    // Create a Blob and a temporary download link
    const blob = new Blob([html], { type: 'text/html' });
    const url  = URL.createObjectURL(blob);

	const time = new Date().toLocaleTimeString('en-GB', { hour12: false });
    const a = document.createElement('a');
    a.href = url;
    a.download = `page-snapshot-${time}.html`;
    a.click();

    // Clean up the temporary object URL
    URL.revokeObjectURL(url);
  });
