
BEGIN { # set test env otherwise get development config settings - unless explicitly
    # set at command-line: "export DANCER_ENVIRONMENT=development; prove -lv t/"
    $ENV{DANCER_ENVIRONMENT} ||= $ENV{PLACK_ENV} ||= 'test';
}

use DPAE::Test; # imports all deps
# say "$_: $INC{$_}" for sort keys %INC;

=begin # how to access app internals:
my $app = DPAE::app; warn Dumper $app;
my $cfg = $app->settings->{plugins}->{'Auth::Extensible'}->{realms}->{database};
=cut

sub debug { say shift->content; }

my $app = DPAE->to_app;
my $test = Plack::Test->create($app);
{
    my $response = $test->request( GET '/' );                # debug($response);
    is( $response->code, 200, '[GET /] success' );
}
{
    my $response = $test->request( GET '/admin' );           # debug ($response);
    is( $response->is_redirect, 1, '[GET /admin] is redirect ...' );
    like( $response->content, qr{http://localhost/login},
        '   to localhost/login page' );
}
{
    my $response = $test->request( GET '/beer' );            # debug($response);
    is( $response->is_redirect, 1, '[GET /beer] is redirect ...' );
    like( $response->content, qr{http://localhost/login},
        '   to localhost/login page' );
}
{
    my $response = $test->request( GET '/keys_to_safe' );     # debug($response);
    is( $response->is_redirect, 1, '[GET /keys_to_safe] is redirect ...' );
    like( $response->content, qr{http://localhost/login},
        '   to localhost/login page' );
}

=begin
don't know how to do login & redirect using Plack::Test, just get another redirect
Plack::Test not recommended for D2 tests anyway, use LWP::Protocol::PSGI
{
    my %user = (  username => 'admin', password => 'admin' );
    my $response = $test->request( POST '/login', \%user );  debug($response);
}
=cut

my $psgi_app = DPAE::runner()->psgi_app;
LWP::Protocol::PSGI->register($psgi_app);
my $mech = Test::WWW::Mechanize->new;

{
    $mech->get('http://localhost/admin');                        #  debug($mech);
    $mech->content_contains( 'You need to log in to continue', '/admin login required' );
    $mech->submit_form( fields => { username => 'admin', password => 'admin' } );
    $mech->content_contains( 'you have Admin role', 'have Admin role' ); # debug($mech);
}
{
    $mech->get('http://localhost/keys_to_safe');                 # debug($mech);
    $mech->content_contains( 'locked inside safe!!', '/keys_to_safe OK' );
}
{
    $mech->get('http://localhost/beer');                         # debug($mech);
    $mech->content_contains( 'Permission Denied', '/beer denied' );
    $mech->get('http://localhost/logout');                        # debug($mech);
    # $mech->content_contains( 'logged out successfully', 'logged out'); # using exit_page:
    $mech->content_contains( 'Login Required', 'logged out');
}
{
    $mech->get('http://localhost/beer');                         # debug($mech);
    $mech->content_contains( 'You need to log in to continue', '/beer login required' );
    $mech->submit_form( fields => { username => 'swiller', password => 'swiller' } );
    $mech->content_contains( 'you have BeerDrinker role', 'have BeerDrinker role' ); #  debug($mech);
}
{
    $mech->get('http://localhost/keys_to_safe');                 # debug($mech);
    $mech->content_contains( 'Permission Denied', '/keys_to_safe denied' );
}

{
    $mech->get('http://localhost/drink');                         # debug($mech);
    $mech->content_contains( 'you can drink', '/drink OK' );
    $mech->get('http://localhost/logout');                        # debug($mech);
    # $mech->content_contains( 'logged out successfully', 'logged out'); # using exit_page:
    $mech->content_contains( 'Login Required', 'logged out');
}

{ # provider = DB:
    $mech->get('http://localhost/get_drunk');                     # debug($mech);
    $mech->content_contains( 'You need to log in to continue', '/get_drunk login required' );
    $mech->submit_form( fields => { username => 'test', password => 'test' } ); # debug($mech);
    $mech->content_contains( 'Permission Denied', '/get_drunk denied' );

    $mech->get('http://localhost/test');                         # debug($mech);
    $mech->content_contains( 'test access success', '/test OK' );
    $mech->get('http://localhost/logout');                        # debug($mech);
}
{ # provider = DB:
    $mech->get('http://localhost/get_drunk');                     # debug($mech);
    $mech->content_contains( 'You need to log in to continue', '/get_drunk login required' );
    # uses has both roles BeerDrinker & VodkaDrinker:
    $mech->submit_form( fields => { username => 'booza', password => 'booza' } ); # debug($mech);
    $mech->content_contains( 'you are drunk!!', '/get_drunk OK' );
}

done_testing(22);
