package DPAE::Test;

# imports lib paths, Modern::Perl, etc into t/ scripts

use Modern::Perl;

use Import::Into;
use Exporter ();
use FindBin; # warn $FindBin::Bin;

use lib '/home/raj/perl-lib';
use Local::DB;

my $SCHEMA_SET = 0; # warn $SCHEMA_SET;
init_db() || die 'initialise db failed';

open my $fh, '>' . $FindBin::Bin . '/mech.htm' or die $!;

sub print_output {
    my $response = shift;
    print $fh $response->{content};
}

sub get_dbix { Local::DB->dbix({ dsn => 'dbi:SQLite:dbname=:memory:' }) }

sub init_db {
    return 1 if $SCHEMA_SET; # warn 'here';

    my $dbix = get_dbix();
    my @schema = _schema();
    do { $dbix->dbh->do($_) || die $dbix->error } foreach @schema; # $dbix->error doesn't work here
    return ++$SCHEMA_SET;
}

our @EXPORT = qw(print_output get_dbix);

sub import {
    HTTP::Request::Common->import::into(1);
    Test::WWW::Mechanize->import::into(1);
    LWP::Protocol::PSGI->import::into(1);
    Data::Printer->import::into(1); # doesn't import p()
    Data::Dumper->import::into(1);
    Modern::Perl->import::into(1);
    Local::Utils->import::into(1);
    Plack::Test->import::into(1);
    YAML::Tiny->import::into(1);
    Test::More->import::into(1);
    Local::DB->import::into(1);
    DPAE->import::into(1);

    goto &Exporter::import;
}

1;

sub _schema {
    return (
        q{
            CREATE TABLE users(
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                username TEXT,
                last_name TEXT,
                first_name TEXT,
                password TEXT
            )
        },
        # password = ~/scripts/sha1_digest.pl <username> for users:
        q{
            INSERT INTO users
                SELECT 1 as id,
                    'test' as username,
                    'tess' as first_name,
                    'tickle' as last_name,
                    'qUqP5cyxm6YcTAhz05Hph5gvu9M' as password
                UNION ALL SELECT 2, 'booza', 'kin', 'ammerd', 'YwkiGtviEPxZg3iWQJ9HIMv8QMQ';
        },
        q{
            CREATE TABLE roles (
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                role TEXT
            )
        },
        q{
            INSERT INTO roles
                SELECT 1 as id, 'TestRole' as role
                UNION ALL SELECT 2, 'BeerDrinker'
                UNION ALL SELECT 3, 'VodkaDrinker';
        },
        q{
            CREATE TABLE user_role(
                user_id INT,
                role_id INT
            )
        },
        q{
            INSERT INTO user_role
                SELECT 1 as user_id, 1 as role_id
                UNION ALL SELECT 2, 2
                UNION ALL SELECT 2, 3;
        },
        q{
            CREATE VIEW user_role_view AS
                SELECT u.id as user_id, r.role as function_name
                FROM users u
				JOIN user_role ur on ur.user_id = u.id
				JOIN roles r on ur.role_id = r.id
        },
    );
}
