package DPAE;
#=======================================================
# **** do not use Shotgun - resets session every request
#=======================================================

use Dancer2;
use DPAE::Plugin::Admin;
use Dancer2::Plugin::Auth::Extensible;

use Data::Dumper;
use Data::Printer alias => 'ddp';

our $VERSION = '0.1';

set auto_page => 1; # /denied (DPAE)

# hook before => sub { my $session = session; ddp $session; };
hook before => sub { _debug('=' x 80) };

hook before_template_render => sub {
    my $tokens = shift;
};

get '/' => sub {
    my $session = session; # p $session;
    template 'index';
};

get '/admin' => require_role Admin => sub {
	return 'you have Admin role';
};

get '/beer' => require_role BeerDrinker => sub {
    my $user = logged_in_user; # ddp $user;
	return 'you have BeerDrinker role';
};

get '/bar' => require_role NoExists => sub {
	return "you'll never get here!!";
};

get '/register' => require_role register => sub {
    my $user = logged_in_user; # ddp $user; # user_profile href
	return "you have 'register' role";
};

get '/users' => require_login sub {
    my $user = logged_in_user; # ddp $user; # user_profile href
    return "Hi there, $user->{username}";
};

get '/foo' => sub {
    if ( authenticate_user('swiller','swiller','config') ) {
        my $user = logged_in_user; # ddp $user;
        return $user->{name};
    }
    return 'user not authenticated';
};

get '/wine' => sub {
    if ( authenticate_user('') ) {

    }
    else {

    }
};

get '/drink' => require_any_role [qw(BeerDrinker VodkaDrinker)] => sub {
    return 'you can drink';
};

get '/get_drunk' => require_all_roles [qw(BeerDrinker VodkaDrinker)] => sub {
    return 'you are drunk!!';
};

get '/test' => require_role TestRole => sub {
    return 'test access success';
};

# DPAE::Plugin::Admin:
get '/keys_to_safe' => needs_admin sub {
    return 'locked inside safe!!';
};

any '/logout' => sub {
    app->destroy_session;
	redirect '/';
};

sub permission_denied { template denied => {}, { layout => undef } }

sub _debug {
    return unless app->environment eq 'development';
    ddp @_;
}

=begin # auto-login:
get '/login' => sub {
	session logged_in_user => 'raj';
	session logged_in_user_realm => 'config';
    #redirect '/';
};
=cut

true;
